"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var MysqlExceptionFilter_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MysqlExceptionFilter = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
let MysqlExceptionFilter = MysqlExceptionFilter_1 = class MysqlExceptionFilter {
    logger = new common_1.Logger(MysqlExceptionFilter_1.name);
    catch(exception, host) {
        const ctx = host.switchToHttp();
        const response = ctx.getResponse();
        const request = ctx.getRequest();
        let status = common_1.HttpStatus.BAD_REQUEST;
        let message = 'Database error';
        const err = exception;
        if (err.code === 'ER_DUP_ENTRY' || err.code === '23505') {
            status = common_1.HttpStatus.CONFLICT;
            message = 'Duplicate entry error';
        }
        this.logger.error(`Database Error: ${JSON.stringify(err)}`);
        response.status(status).json({
            statusCode: status,
            timestamp: new Date().toISOString(),
            path: request.url,
            error: message,
        });
    }
};
exports.MysqlExceptionFilter = MysqlExceptionFilter;
exports.MysqlExceptionFilter = MysqlExceptionFilter = MysqlExceptionFilter_1 = __decorate([
    (0, common_1.Catch)(typeorm_1.QueryFailedError)
], MysqlExceptionFilter);
//# sourceMappingURL=mysql-exception.filter.js.map